;;;---------------------------------------------------------------;;;
;;;                                                               ;;;
;;;                  HIP ROOF - 2D RIDGE EDGES                    ;;;
;;;                 (SLOWER BUT CORRECT VERSION)                  ;;;
;;;                                                               ;;;
;;;  Author : Marko Ribar, d.i.a. (architect)                     ;;;
;;;  Autolisp routine for AutoCAD or BricsCAD                     ;;;
;;;  Copyright (C) 2021.                                          ;;;
;;;  Tested and programmed on Windows 10 OS                       ;;;
;;;  Bugs or failures may appear and aren't authors responsibility;;;
;;;  LSP file is free to be used for improvements...              ;;;
;;;  All relevant suggestions are welcomed...                     ;;;
;;;                                                               ;;;
;;;---------------------------------------------------------------;;;

(defun c:roof-command-new ( / *error* 2droof3d 3pline duplicates coplanar-p acos angle3d unique unit v^v clean_poly clockwise-lw processlines process process3ds 4pt-3ds cmde pea ucsf s ti lw lwx pl pll tl v1 v2 tll tlll ss 3df regobj 3ds el lil lix ch chh slope ang r lwss regl minpt maxpt 3dsl elev lwe var ll q e1 e2 e1min e1max e2min e2max n lill plx del z plll p ppl 3tl 3tll lill1 lill2 pp ip 3dfl fuzz vlen exthig1 exthig2 singles tllo )

  (or cad
    (if (vl-catch-all-error-p (setq cad (vl-catch-all-apply (function vlax-get-acad-object) nil)))
      (progn
        (vl-load-com)
        (setq cad (vlax-get-acad-object))
      )
    )
  )
  (or doc (setq doc (vla-get-activedocument cad)))
  (or alo (setq alo (vla-get-activelayout doc)))
  (or spc (setq spc (vla-get-block alo)))

  (defun *error* ( m )
    (if cmde
      (setvar (quote cmdecho) cmde)
    )
    (if pea
      (setvar (quote peditaccept) pea)
    )
    (if (and (= ch "3D") lwe)
      (foreach lw lwe
        (if (not (vlax-erased-p lw))
          (entdel lw)
        )
      )
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun 2droof3d ( poly / ListClockwise-p mid _ilpp make3dlw ent tmp tot big reg vl ml ss lst el )

    (defun ListClockwise-p ( lst / z vlst )
      (vl-catch-all-apply (function minusp)
        (list
          (if
            (not
              (equal 0.0
                (setq z
                  (apply (function +)
                    (mapcar
                      (function
                        (lambda ( u v )
                          (- (* (car  u) (cadr  v)) (* (car  v) (cadr  u)))
                        )
                      )
                      (setq vlst
                        (mapcar
                          (function
                            (lambda ( a b ) (mapcar (function -) b a))
                          )
                          (mapcar (function (lambda ( x ) (car lst))) lst)
                          (cdr (reverse (cons (car lst) (reverse lst))))
                        )
                      )
                      (cdr (reverse (cons (car vlst) (reverse vlst))))
                    )
                  )
                ) 1e-6
              )
            )
            z
            (progn
              (prompt "\n\nChecked vectors are colinear - unable to determine clockwise-p of list")
              nil
            )
          )
        )
      )
    )

    (defun mid ( p1 p2 )
      (mapcar (function (lambda ( a b ) (/ (+ a b) 2.0))) p1 p2)
    )

    (defun _ilpp ( p1 p2 t1 t2 t3 / v^v unit _ilp nor o )

      (defun v^v ( u v )
        (list
          (- (* (cadr u) (caddr v)) (* (cadr v) (caddr u)))
          (- (* (car  v) (caddr u)) (* (car  u) (caddr v)))
          (- (* (car  u) (cadr  v)) (* (car  v) (cadr  u)))
        )
      )

      (defun unit ( v / d )
        (if (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-8))
          (mapcar (function (lambda ( x ) (/ x d))) v)
          (progn
            (prompt "\nStrength of vector near 0.0... Invalid input specification... Quitting...")
            (exit)
          )
        )
      )

      (defun _ilp ( p1 p2 o nor / p1p p2p op tp pp p )
        (if (not (equal (v^v nor (unit (mapcar (function -) p2 p1))) (list 0.0 0.0 0.0) 1e-7))
          (progn
            (setq p1p (trans p1 0 (v^v nor (unit (mapcar (function -) p2 p1))))
                  p2p (trans p2 0 (v^v nor (unit (mapcar (function -) p2 p1))))
                  op  (trans o 0 (v^v nor (unit (mapcar (function -) p2 p1))))
                  op  (list (car op) (cadr op) (caddr p1p))
                  tp  (polar op (+ (* 0.5 pi) (angle (list 0.0 0.0 0.0) (trans nor 0 (v^v nor (unit (mapcar (function -) p2 p1)))))) 1.0)
            )
            (if (inters p1p p2p op tp nil)
              (progn
                (setq p (trans (inters p1p p2p op tp nil) (v^v nor (unit (mapcar (function -) p2 p1))) 0))
                p
              )
              nil
            )
          )
          (progn
            (setq pp (list (car (trans p1 0 nor)) (cadr (trans p1 0 nor)) (caddr (trans o 0 nor))))
            (setq p (trans pp nor 0))
            p
          )
        )
      )

      (setq nor (unit (v^v (mapcar (function -) t3 t1) (mapcar (function -) t2 t1))))
      (setq o t1)
      
      (if (_ilp p1 p2 o nor)
        (_ilp p1 p2 o nor)
        nil
      )
    )

    (defun make3dlw ( lwp / vl vlu vlup z )
      (setq vl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget lwp))))
      (setq vl (mapcar (function (lambda ( x ) (trans x lwp 0))) vl))
      (setq vlu (mapcar (function (lambda ( x ) (_ilpp x (mapcar (function +) x (list 0.0 0.0 1.0)) (trans (list 0.0 0.0 0.0) 1 0) (trans (list 1.0 0.0 0.0) 1 0) (trans (list 0.0 1.0 0.0) 1 0)))) vl))
      (setq vlup (mapcar (function (lambda ( x ) (trans x 0 (trans (list 0.0 0.0 1.0) 1 0 t)))) vlu))
      (setq z (- (caddr (trans (list 0.0 0.0 0.0) 0 1))))
      (entmake
        (append
          (list
            (cons 0 "LWPOLYLINE")
            (cons 100 "AcDbEntity")
            (cons 100 "AcDbPolyline")
            (cons 90 (length vl))
            (cons 70 1)
            (cons 38 z)
          )
          (mapcar (function (lambda ( x ) (list 10 (car x) (cadr x)))) vlup)
          (list (cons 210 (trans (list 0.0 0.0 1.0) 1 0 t)))
        )
      )
      (setq vl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget (entlast)))))
      (setq vl (mapcar (function (lambda ( x ) (trans x (entlast) 0))) vl))
      (if (vl-every (function (lambda ( x ) (equal (caddr (trans x 0 1)) 0.0 1e-6))) vl)
        (entlast)
        (progn
          (entdel (entlast))
          (setq vlup (mapcar (function (lambda ( x ) (trans x 0 1))) vlu))
          (vl-cmdf "_.PLINE")
          (foreach p vlup
            (vl-cmdf "_non" p)
          )
          (vl-cmdf "_C")
          (entlast)
        )
      )
    )

  ;-----------------------------------------------------------------------------------------------------------------------------------

    (setq tot 0.0)
    (setq vl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget poly))))
    (setq vl (mapcar (function (lambda ( x ) (trans x poly 0))) vl))
    (if (not (equal (car vl) (last vl) 1e-8)) (setq vl (reverse (cons (car vl) (reverse vl)))))
    (if (ListClockwise-p vl) (setq vl (reverse vl)))
    (setq ml (mapcar (function (lambda ( a b ) (mid a b))) vl (cdr vl)))

    (vl-cmdf "_.EXPLODE" poly)
    (setq lil (append lil (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex (ssget "_P"))))))
    
    (setq lst (mapcar (function vlax-ename->vla-object) lil))
    (setq reg (vlax-invoke spc (quote addregion) lst))

    (foreach r reg
      (setq ent (entlast))
      (vl-cmdf "_.PEDIT" "_M")
      (apply (function vl-cmdf) (mapcar (function vlax-vla-object->ename) (vlax-invoke r (quote explode))))
      (vl-cmdf "" "_J" "" "")
      (if
        (and
          (not (eq ent (setq ent (entlast))))
          (= "LWPOLYLINE" (cdr (assoc 0 (entget ent))))
        )
        (progn
          (setq tmp (vlax-curve-getarea ent))
          (setq tot (+ tot tmp))
          (if (< (car big) tmp)
            (setq big (list tmp ent))
          )
        )
      )
      (vla-delete r)
    )
    (if (equal (car big) (/ tot 2.0) 1e-3)
      (entdel (cadr big))
    )

    (setq ss (ssadd))

    (mapcar 
      (function (lambda ( a b c / p1 p2 zl lw 3dlw )
        (progn
          (setq p1 (osnap (mapcar (function +) a (mapcar (function *) (list 0.1 0.1 0.1) (mapcar (function -) b a))) "_nea"))
          (setq p2 (osnap (mapcar (function +) a (mapcar (function *) (list 0.9 0.9 0.9) (mapcar (function -) b a))) "_nea"))
          (setq zl (list (list (apply (function min) (mapcar (function car) (list a b))) (apply (function min) (mapcar (function cadr) (list a b)))) (list (apply (function max) (mapcar (function car) (list a b))) (apply (function max) (mapcar (function cadr) (list a b))))))
          (vl-cmdf "_.ZOOM" "_W" (car zl) (cadr zl))
          (if (= (sslength (ssget "_CP" (list (polar p1 (+ (angle p1 p2) (* 0.5 pi)) 1e-3) (polar p1 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* 0.5 pi)) 1e-3)) (list (cons 0 "LWPOLYLINE,LINE")))) 2)
            (progn
              (vl-cmdf "_.UCS" "_3P" "_non" a "_non" b "")
              (vl-cmdf "_.UCS" "_3P" "_non" (list 0.0 0.0 0.0) "_non" (list 1.0 0.0 0.0) "_non" (list 0.0 (cos (* (/ ang 180.0) pi)) (sin (* (/ ang 180.0) pi))))
              (if (and (setq s (ssget "_C" (osnap (trans c 0 1) "_mid") (osnap (trans c 0 1) "_nea") (list (cons 0 "LWPOLYLINE")))) (setq lw (ssname s 0)))
                (progn
                  (setq 3dlw (make3dlw lw))
                  (setq el (entlast))
                  (vl-cmdf "_.LOFT" lw 3dlw "" "")
                  (if (not (eq el (entlast)))
                    (progn
                      (ssadd (entlast) ss)
                      (if (entget lw) (entdel lw))
                      (if (entget 3dlw) (entdel 3dlw))
                      (vl-cmdf "_.UCS" "_P")
                      (vl-cmdf "_.UCS" "_P")
                    )
                    (progn
                      (vl-cmdf "_.EXTRUDE" lw "" 1e+6 "")
                      (setq el (entlast))
                      (vla-move (vlax-ename->vla-object 3dlw) (vlax-3d-point (list 0.0 0.0 0.0)) (vlax-3d-point (list 0.0 0.0 fuzz)))
                      (vl-cmdf "_.SLICE" el "" "_OB" 3dlw "_non" (list 0.0 0.0 (- elev 1.0)))
                      (ssadd el ss)
                      (if (entget lw) (entdel lw))
                      (if (entget 3dlw) (entdel 3dlw))
                      (vl-cmdf "_.UCS" "_P")
                      (vl-cmdf "_.UCS" "_P")
                    )
                  )
                )
                (progn
                  (vl-cmdf "_.UCS" "_P")
                  (vl-cmdf "_.UCS" "_P")
                )
              )
            )
          )
          (vl-cmdf "_.ZOOM" "_P")
        )
      )) vl (cdr vl) ml
    )

    (foreach obj lst (vla-delete obj))

    (vl-cmdf "_.UNION" ss "")
    (vl-cmdf "_.UCS" "_P")
  )

  (defun 3pline ( p1 p p2 )
    (equal (distance p1 p2) (+ (distance p1 p) (distance p p2)) 1e-6)
  )

  (defun duplicates ( lst / x r )
    (while (setq x (car lst))
      (setq lst (cdr lst))
      (if (vl-some (function (lambda ( q ) (equal q x 1e-6))) lst)
        (progn
          (setq r (cons x r))
          (setq lst (vl-remove-if (function (lambda ( q ) (equal q x 1e-6))) lst))
        )
      )
    )
    (reverse r)
  )

  (defun coplanar-p ( p1 p2 p3 p4 )
    (
      (lambda ( n )
        (equal
          (last (trans p3 0 n))
          (last (trans p4 0 n))
          1e-6
        )
      )
      (v^v (mapcar (function -) p1 p2) (mapcar (function -) p1 p3))
    )
  )

  (defun acos ( x )
    (cond
      ( (equal x 1.0 1e-8) 0.0 )
      ( (equal x -1.0 1e-8) pi )
      ( (and (not (minusp x)) (equal x 0.0 1e-8)) (/ pi 2.0) )
      ( (and (minusp x) (equal x 0.0 -1e-8)) (* 3.0 (/ pi 2.0)) )
      ( (atan (sqrt (- 1.0 (* x x))) x) )
    )
  )

  (defun angle3d ( p1 por p2 / vec1 vec2 dd ang )
    (setq vec1 (unit (mapcar (function -) p1 por)))
    (setq vec2 (unit (mapcar (function -) p2 por)))
    (setq dd (distance vec1 vec2))
    (setq ang (acos (- 1.0 (/ (expt dd 2) 2.0))))
    (if (minusp ang) (+ ang pi) ang)
  )

  (defun unique ( lst / a ll )
    (while (setq a (car lst))
      (if (vl-some (function (lambda ( x ) (equal x a 1e-6))) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-6))) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun unit ( v / d )
    (if (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-8))
      (mapcar (function (lambda ( x ) (/ x d))) v)
      (progn
        (prompt "\nStrength of vector near 0.0... Invalid input specification... Quitting...")
        (exit)
      )
    )
  )

  (defun v^v ( u v )
    (list
      (- (* (cadr u) (caddr v)) (* (caddr u) (cadr v)))
      (- (* (caddr u) (car v)) (* (car u) (caddr v)))
      (- (* (car u) (cadr v)) (* (cadr u) (car v)))
    )
  )

  (defun clean_poly ( lw / plll pos pre suf k lwx )
    (setq plll (reverse (cdr (reverse pll))))
    (setq pos (mapcar (function (lambda ( a b c ) (if (equal (distance a c) (+ (distance a b) (distance b c)) 1e-3) t nil))) (cons (last plll) plll) plll (append (cdr plll) (list (car plll)))))
    (if (apply (function or) pos)
      (progn
        (setq k -1)
        (setq pos (vl-remove nil (mapcar (function (lambda ( x ) (progn (setq k (1+ k)) (if (eq x t) k)))) pos)))
        (foreach p pos
          (setq pos (subst (nth p plll) p pos))
        )
        (foreach p pos
          (setq plll (vl-remove-if (function (lambda ( x ) (equal x p 1e-8))) plll))
        )
        (setq pre (reverse (cdr (member (assoc 10 (setq lwx (entget lw))) (reverse lwx)))))
        (setq pre (subst (cons 90 (length plll)) (assoc 90 pre) pre))
        (setq suf (append (mapcar (function (lambda ( x ) (cons 10 (trans x 0 (cdr (assoc 210 lwx)))))) plll) (list (assoc 210 lwx))))
        (entmod (append pre suf))
      )
    )
    (entupd lw)
  )

  (defun clockwise-lw ( lw / minpt maxpt p1 p2 p3 p4 pmax )
    (vla-getboundingbox (vlax-ename->vla-object lw) (quote minpt) (quote maxpt))
    (mapcar (function set) (list (quote minpt) (quote maxpt)) (mapcar (function safearray-value) (list minpt maxpt)))
    (setq p1 minpt p2 (list (car maxpt) (cadr minpt)) p3 maxpt p4 (list (car minpt) (cadr maxpt)))
    (setq p1 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p1)))
    (setq p2 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p2)))
    (setq p3 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p3)))
    (setq p4 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p4)))
    (setq pmax (max p1 p2 p3 p4))
    (cond
      ( (and (= pmax p1) (> p2 p4))
        t
      )
      ( (and (= pmax p2) (> p3 p1))
        t
      )
      ( (and (= pmax p3) (> p4 p2))
        t
      )
      ( (and (= pmax p4) (> p1 p3))
        t
      )
      ( t nil )
    )
  )

  (defun 4pt-3ds ( p1 p2 p3 p4 / var 3df regobj 3ds e1 e2 c1 c2 )
    (if (not (coplanar-p p1 p2 p3 p4))
      (progn
        (if (not (vl-catch-all-error-p (setq var (vl-catch-all-apply (function vla-addregion) (list (vlax-ename->vla-object (cdr (assoc 330 lwx))) (vlax-safearray-fill (vlax-make-safearray vlax-vbObject (cons 0 0)) (list (vlax-ename->vla-object (setq 3df (entmakex (list (cons 0 "3DFACE") (cons 10 p1) (cons 11 p1) (cons 12 p2) (cons 13 p3))))))))))))
          (progn
            (setq regobj (car (safearray-value (variant-value var))))
            (if (not (vlax-erased-p 3df))
              (entdel 3df)
            )
          )
          (progn
            (vl-cmdf "_.CONVTOSURFACE" 3df "")
            (setq regobj (vlax-ename->vla-object (entlast)))
          )
        )
        (vl-cmdf "_.EXTRUDE" (vlax-vla-object->ename regobj) "" "_D" "_non" p1 "_non" p4)
        (vla-slicesolid (vlax-ename->vla-object (setq 3ds (entlast))) (vlax-3d-point (mapcar (function +) (list 0.0 0.0 fuzz) p2)) (vlax-3d-point (mapcar (function +) (list 0.0 0.0 fuzz) p3)) (vlax-3d-point (mapcar (function +) (list 0.0 0.0 fuzz) p4)) :vlax-true)
        (if (vlax-erased-p 3ds)
          (progn
            (setq e1 (entlast))
            (entdel e1)
            (setq e2 (entlast))
            (entdel e1)
            (setq c1 (safearray-value (variant-value (vla-get-centroid (vlax-ename->vla-object e1)))))
            (setq c2 (safearray-value (variant-value (vla-get-centroid (vlax-ename->vla-object e2)))))
            (if (< (distance p1 c1) (distance p1 c2))
              (progn
                (setq 3ds e1)
                (entdel e2)
              )
              (progn
                (setq 3ds e2)
                (entdel e1)
              )
            )
          )
          (progn
            (setq e1 (entlast))
            (setq c1 (safearray-value (variant-value (vla-get-centroid (vlax-ename->vla-object e1)))))
            (if (< (distance p1 c1) (distance p1 (safearray-value (variant-value (vla-get-centroid (vlax-ename->vla-object 3ds))))))
              (progn
                (entdel 3ds)
                (setq 3ds e1)
              )
              (entdel e1)
            )
          )
        )
      )
    )
    3ds
  )

  (defun processlines ( lil / process e x lst )

    (defun process ( lst / ridgechk processl r qq )

      (defun ridgechk ( midp p1 p2 )
        (and (> (length (vl-remove-if-not (function (lambda ( x ) (equal (unit (v^v (mapcar (function -) (cadar x) (caar x)) (mapcar (function -) midp (caar x)))) (cadr x) 5e-4))) tllo)) 1) (not (vl-some (function (lambda ( x ) (and (vl-some (function (lambda ( y ) (equal y (mapcar (function +) (list 0.0 0.0) p1) 1e-8))) x) (vl-some (function (lambda ( y ) (equal y (mapcar (function +) (list 0.0 0.0) p2) 1e-8))) x)))) qq)))
      )

      (defun processl ( lst / lill pl dupes dd p li )
        (setq lill (mapcar (function cadr) lst))
        (setq pl (apply (function append) (mapcar (function cadr) lst)))
        (setq dupes (duplicates pl))
        (while (setq p (car dupes))
          (while (setq li (car lill))
            (if (vl-some (function (lambda ( x ) (equal p x 1e-8))) li)
              (if
                (and
                  (setq lii
                         (vl-some
                           (function
                             (lambda ( y )
                               (if
                                 (and
                                   (= (length (vl-remove-if (function (lambda ( g ) (equal g p 1e-8))) y)) 1)
                                   (3pline
                                     (car (vl-remove-if (function (lambda ( q ) (equal q p 1e-8))) li))
                                     p
                                     (car (vl-remove-if (function (lambda ( w ) (equal w p 1e-8))) y))
                                   )
                                 )
                                  y
                               )
                             )
                           )
                           (vl-remove-if (function (lambda ( m ) (equal m li 1e-8))) lill)
                         )
                  )
                  (not (vl-some
                         (function (lambda ( i ) (vl-some (function (lambda ( j ) (equal j p 1e-8))) i)))
                         (vl-remove-if
                           (function (lambda ( k ) (equal k li 1e-8)))
                           (vl-remove-if (function (lambda ( m ) (equal m lii 1e-8))) lill)
                         )
                       )
                  )
                )
                (progn
                  (setq dupes (vl-remove-if (function (lambda ( x ) (equal x p 1e-8))) dupes))
                  (if (and (setq dd (vl-some (function (lambda ( x ) (if (equal li (cadr x) 1e-8) x))) lst)) (not (vlax-erased-p (car dd))))
                    (entdel (car dd))
                  )
                  (if (and (setq dd (vl-some (function (lambda ( x ) (if (equal lii (cadr x) 1e-8) x))) lst)) (not (vlax-erased-p (car dd))))
                    (entdel (car dd))
                  )
                  (setq lst (vl-remove-if (function (lambda ( x ) (equal li (cadr x) 1e-8))) lst))
                  (setq lst (vl-remove-if (function (lambda ( x ) (equal lii (cadr x) 1e-8))) lst))
                  (setq lst
                         (cons
                           (list
                             (entmakex
                               (list
                                 (cons 0 "LINE")
                                 (cons 10
                                       (car (vl-remove-if (function (lambda ( x ) (equal x p 1e-8))) li))
                                 )
                                 (cons 11
                                       (car (vl-remove-if (function (lambda ( x ) (equal x p 1e-8))) lii))
                                 )
                               )
                             )
                             (list (car (vl-remove-if (function (lambda ( x ) (equal x p 1e-8))) li))
                                   (car (vl-remove-if (function (lambda ( x ) (equal x p 1e-8))) lii))
                             )
                           )
                           lst
                         )
                  )
                )
              )
            )
            (setq lill (vl-remove-if (function (lambda ( x ) (equal x li 1e-8))) lill))
          )
          (progn
            (setq lill (mapcar (function cadr) lst))
            (setq dupes (vl-remove-if (function (lambda ( x ) (equal x p 1e-8))) dupes))
          )
        )
        lst
      )

      (setq qq (mapcar (function (lambda ( x ) (mapcar (function cdr) (vl-remove-if (function (lambda ( w ) (/= (car w) 10))) (entget x))))) lwe))
      (foreach li lst
        (if (and (not (and (equal (last (caadr li)) elev 1e-8) (equal (last (cadadr li)) elev 1e-8))) (not (ridgechk (mapcar (function (lambda ( a b ) (/ (+ a b) 2.0))) (caadr li) (cadadr li)) (caadr li) (cadadr li))))
          (progn
            (entdel (car li))
            (setq lst (vl-remove li lst))
          )
        )
      )
      (setq r lst)
      (while (/= (length r) (length (setq r (processl r)))))
      (mapcar (function car) r)
    )

    (if lil
      (progn
        (repeat (length lil)
          (setq e (car lil))
          (setq lil (cdr lil))
          (setq x (entget e))
          (setq lst (cons (list e (list (cdr (assoc 10 x)) (cdr (assoc 11 x)))) lst))
        )
        (process lst)
      )
    )
  )

  (defun process ( lw / subtractchk modelling tll )

    (defun subtractchk ( 3ds el )
      (if (vlax-erased-p 3ds)
        (progn
          (if (vlax-erased-p el)
            (if (/= (cdr (assoc 0 (entget (entlast)))) "3DSOLID")
              (progn
                (princ "\nERROR OF SUBTRACT COMMAND... Not valid output entity type... Both main and subtracting 3DSOLID entities were erased and further more last entity in not 3DSOLID... Quitting...")
                (exit)
              )
              (progn
                (princ "\nERROR OF SUBTRACT COMMAND... Both main and subtracting 3DSOILD were erased, but last entity is 3DSOLID... It is unknown weather new 3DSOLID was created after SUBTRACT command and wather it should become main 3DSOLID for further processing... Quitting...")
                (exit)
              )
            )
            (progn
              (princ "\nERROR OF SUBTRACT COMMAND... Main 3DSOLID was erased during SUBTRACT command, but subtracting 3DSOLID is still present... It is unknown weather subtracting 3DSOLID should become main 3DSOLID for further processing... Quitting...")
              (exit)
            )
          )
          (if (/= (cdr (assoc 0 (entget (entlast)))) "3DSOLID")
            (progn
              (princ "\nERROR OF SUBTRACT COMMAND... Not valid output entity type... Main 3DSOLID was erased during SUBTRACT command and further more last entity is not 3DSOLID... Quitting...")
              (exit)
            )
            (progn
              (princ "\nERROR OF SUBTRACT COMMAND... Not valid output entity type... Main 3DSOLID was erased during SUBTRACT command, but last entity is 3DSOLID... It is unknown weather last entity that is 3DSOLID should bacome main 3DSOLID for further processing... Quitting...")
              (exit)
            )
          )
        )
      )
    )

    (defun modelling nil
      (setq tlll (mapcar (function (lambda ( t1 t2 t3 / v1 v2 ip p1 p2 ) (setq v1 (unit (v^v (cadr t1) (cadr t2))) v2 (unit (v^v (cadr t2) (cadr t3))) ip (inters (caar t2) (mapcar (function +) (caar t2) v1) (caar t3) (mapcar (function +) (caar t3) v2) nil)) (if (and (null ip) (not (equal v1 (mapcar (function -) v2) 1e-6)) (not (equal v1 v2 1e-6)) (coplanar-p (caar t2) (mapcar (function +) (caar t2) v1) (caar t3) (mapcar (function +) (caar t3) v2))) (setq ip (trans (inters (append (mapcar (function +) (list 0.0 0.0) (trans (caar t2) 0 (v^v v1 v2))) (list (setq z (caddr (trans (caar t2) 0 (v^v v1 v2)))))) (append (mapcar (function +) (list 0.0 0.0) (trans (mapcar (function +) (caar t2) v1) 0 (v^v v1 v2))) (list z)) (append (mapcar (function +) (list 0.0 0.0) (trans (caar t3) 0 (v^v v1 v2))) (list z)) (append (mapcar (function +) (list 0.0 0.0) (trans (mapcar (function +) (caar t3) v2) 0 (v^v v1 v2))) (list z)) nil) (v^v v1 v2) 0))) (if ip (progn (cond ( (minusp (- (caddr ip) (cdr (assoc 38 lwx)))) (if (minusp (caddr v1)) (setq v1 (mapcar (function -) v1))) (if (minusp (caddr v2)) (setq v2 (mapcar (function -) v2))) ) ( t (if (not (minusp (caddr v1))) (setq v1 (mapcar (function -) v1))) (if (not (minusp (caddr v2))) (setq v2 (mapcar (function -) v2))) ) ) (setq p1 (mapcar (function +) (caar t2) (mapcar (function *) v1 (list vlen vlen vlen)))) (setq p2 (mapcar (function +) (cadar t2) (mapcar (function *) v2 (list vlen vlen vlen)))) (list (car t2) (cadr t2) (list ip p1 p2))) (list (car t2) (cadr t2) (list (caar t2) (if (< (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar t2) (caar t2))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (if (minusp (caddr v1)) (mapcar (function -) v1) v1))) (* 0.5 pi)) (append (polar (mapcar (function +) (list 0.0 0.0) (caar t2)) (+ (angle (caar t2) (cadar t2)) (* 0.5 pi)) (* 1e+3 (cos (cvunit ang "degree" "radian")))) (list (+ (* 1e+3 (sin (cvunit ang "degree" "radian"))) (cdr (assoc 38 lwx))))) (mapcar (function +) (caar t2) (mapcar (function *) (if (minusp (caddr v1)) (list (- vlen) (- vlen) (- vlen)) (list vlen vlen vlen)) v1))) (if (< (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar t2) (cadar t2))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (if (minusp (caddr v2)) (mapcar (function -) v2) v2))) (* 0.5 pi)) (append (polar (mapcar (function +) (list 0.0 0.0) (cadar t2)) (+ (angle (caar t2) (cadar t2)) (* 0.5 pi)) (* 1e+3 (cos (cvunit ang "degree" "radian")))) (list (+ (* 1e+3 (sin (cvunit ang "degree" "radian"))) (cdr (assoc 38 lwx))))) (mapcar (function +) (cadar t2) (mapcar (function *) (if (minusp (caddr v2)) (list (- vlen) (- vlen) (- vlen)) (list vlen vlen vlen)) v2))) (cadar t2)))))) (cons (last tll) (reverse (cdr (reverse tll)))) tll (append (cdr tll) (list (car tll)))))
      (if (not (vl-catch-all-error-p (setq var (vl-catch-all-apply (function vla-addregion) (list (vlax-ename->vla-object (cdr (assoc 330 lwx))) (vlax-safearray-fill (vlax-make-safearray vlax-vbObject (cons 0 0)) (list (vlax-ename->vla-object lw))))))))
        (setq regobj (car (safearray-value (variant-value var))))
        (setq regobj (vla-copy (vlax-ename->vla-object lw)))
      )
      (vl-cmdf "_.EXTRUDE" (vlax-vla-object->ename regobj) "" "_D" "_non" (list 0.0 0.0 0.0) "_non" (list 0.0 0.0 exthig1))
      (setq 3ds (entlast))
      (foreach tt tlll
        (vl-cmdf "_.UCS" "_ZA" "_non" (caar tt) "_non" (mapcar (function +) (caar tt) (cadr tt)))
        (if (= (length (last tt)) 3)
          (if (minusp (- (caddr (car (last tt))) (cdr (assoc 38 lwx))))
            (cond
              ( (and (>= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (caar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (car (last tt))))) (* 0.5 pi)) (>= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (cadar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (car (last tt))))) (* 0.5 pi)))
                (vl-cmdf "_.PLINE" "_non" (polar (trans (cadr (last tt)) 0 1) (angle (trans (cadar tt) 0 1) (trans (caar tt) 0 1)) 1e-6) "_non" (trans (caar tt) 0 1) "_non" (trans (cadar tt) 0 1) "_non" (polar (trans (caddr (last tt)) 0 1) (angle (trans (caar tt) 0 1) (trans (cadar tt) 0 1)) 1e-6) "_C")
              )
              ( (and (>= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (caar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (car (last tt))))) (* 0.5 pi)) (<= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (cadar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (car (last tt))))) (* 0.5 pi)))
                (vl-cmdf "_.PLINE" "_non" (polar (trans (cadr (last tt)) 0 1) (angle (trans (cadar tt) 0 1) (trans (caar tt) 0 1)) 1e-6) "_non" (trans (caar tt) 0 1) "_non" (trans (cadar tt) 0 1) "_non" (polar (trans (append (polar (mapcar (function +) (list 0.0 0.0) (cadar tt)) (+ (angle (caar tt) (cadar tt)) (* 0.5 pi)) (* 1e+3 (cos (cvunit ang "degree" "radian")))) (list (+ (* 1e+3 (sin (cvunit ang "degree" "radian"))) (cdr (assoc 38 lwx))))) 0 1) (angle (trans (caar tt) 0 1) (trans (cadar tt) 0 1)) 1e-6) "_C")
              )
              ( (and (<= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (caar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (car (last tt))))) (* 0.5 pi)) (>= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (cadar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (car (last tt))))) (* 0.5 pi)))
                (vl-cmdf "_.PLINE" "_non" (polar (trans (append (polar (mapcar (function +) (list 0.0 0.0) (caar tt)) (+ (angle (caar tt) (cadar tt)) (* 0.5 pi)) (* 1e+3 (cos (cvunit ang "degree" "radian")))) (list (+ (* 1e+3 (sin (cvunit ang "degree" "radian"))) (cdr (assoc 38 lwx))))) 0 1) (angle (trans (cadar tt) 0 1) (trans (caar tt) 0 1)) 1e-6) "_non" (trans (caar tt) 0 1) "_non" (trans (cadar tt) 0 1) "_non" (polar (trans (caddr (last tt)) 0 1) (angle (trans (caar tt) 0 1) (trans (cadar tt) 0 1)) 1e-6) "_C")
              )
              ( (and (<= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (caar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (car (last tt))))) (* 0.5 pi)) (<= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (cadar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (car (last tt))))) (* 0.5 pi)))
                (vl-cmdf "_.PLINE" "_non" (polar (trans (append (polar (mapcar (function +) (list 0.0 0.0) (caar tt)) (+ (angle (caar tt) (cadar tt)) (* 0.5 pi)) (* 1e+3 (cos (cvunit ang "degree" "radian")))) (list (+ (* 1e+3 (sin (cvunit ang "degree" "radian"))) (cdr (assoc 38 lwx))))) 0 1) (angle (trans (cadar tt) 0 1) (trans (caar tt) 0 1)) 1e-6) "_non" (trans (caar tt) 0 1) "_non" (trans (cadar tt) 0 1) "_non" (polar (trans (append (polar (mapcar (function +) (list 0.0 0.0) (cadar tt)) (+ (angle (caar tt) (cadar tt)) (* 0.5 pi)) (* 1e+3 (cos (cvunit ang "degree" "radian")))) (list (+ (* 1e+3 (sin (cvunit ang "degree" "radian"))) (cdr (assoc 38 lwx))))) 0 1) (angle (trans (caar tt) 0 1) (trans (cadar tt) 0 1)) 1e-6) "_C")
              )
            )
            (cond
              ( (and (>= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (caar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (car (last tt)) (caar tt)))) (* 0.5 pi)) (>= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (cadar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (car (last tt)) (cadar tt)))) (* 0.5 pi)))
                (vl-cmdf "_.PLINE" "_non" (trans (car (last tt)) 0 1) "_non" (trans (caar tt) 0 1) "_non" (trans (cadar tt) 0 1) "_C")
              )
              ( (and (>= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (caar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (car (last tt)) (caar tt)))) (* 0.5 pi)) (<= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (cadar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (car (last tt)) (cadar tt)))) (* 0.5 pi)))
                (vl-cmdf "_.PLINE" "_non" (trans (car (last tt)) 0 1) "_non" (trans (caar tt) 0 1) "_non" (trans (cadar tt) 0 1) "_non" (polar (trans (append (polar (mapcar (function +) (list 0.0 0.0) (cadar tt)) (+ (angle (caar tt) (cadar tt)) (* 0.5 pi)) (* 1e+3 (cos (cvunit ang "degree" "radian")))) (list (+ (* 1e+3 (sin (cvunit ang "degree" "radian"))) (cdr (assoc 38 lwx))))) 0 1) (angle (trans (caar tt) 0 1) (trans (cadar tt) 0 1)) 1e-6) "_C")
              )
              ( (and (<= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (caar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (car (last tt)) (caar tt)))) (* 0.5 pi)) (>= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (cadar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (car (last tt)) (cadar tt)))) (* 0.5 pi)))
                (vl-cmdf "_.PLINE" "_non" (polar (trans (append (polar (mapcar (function +) (list 0.0 0.0) (caar tt)) (+ (angle (caar tt) (cadar tt)) (* 0.5 pi)) (* 1e+3 (cos (cvunit ang "degree" "radian")))) (list (+ (* 1e+3 (sin (cvunit ang "degree" "radian"))) (cdr (assoc 38 lwx))))) 0 1) (angle (trans (cadar tt) 0 1) (trans (caar tt) 0 1)) 1e-6) "_non" (trans (caar tt) 0 1) "_non" (trans (cadar tt) 0 1) "_non" (trans (car (last tt)) 0 1) "_C")
              )
              ( (and (<= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (cadar tt) (caar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (car (last tt)) (caar tt)))) (* 0.5 pi)) (<= (angle3d (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (caar tt) (cadar tt))) (list 0.0 0.0 0.0) (mapcar (function +) (list 0.0 0.0) (mapcar (function -) (car (last tt)) (cadar tt)))) (* 0.5 pi)))
                (vl-cmdf "_.PLINE" "_non" (polar (trans (append (polar (mapcar (function +) (list 0.0 0.0) (caar tt)) (+ (angle (caar tt) (cadar tt)) (* 0.5 pi)) (* 1e+3 (cos (cvunit ang "degree" "radian")))) (list (+ (* 1e+3 (sin (cvunit ang "degree" "radian"))) (cdr (assoc 38 lwx))))) 0 1) (angle (trans (cadar tt) 0 1) (trans (caar tt) 0 1)) 1e-6) "_non" (trans (caar tt) 0 1) "_non" (trans (cadar tt) 0 1) "_non" (polar (trans (append (polar (mapcar (function +) (list 0.0 0.0) (cadar tt)) (+ (angle (caar tt) (cadar tt)) (* 0.5 pi)) (* 1e+3 (cos (cvunit ang "degree" "radian")))) (list (+ (* 1e+3 (sin (cvunit ang "degree" "radian"))) (cdr (assoc 38 lwx))))) 0 1) (angle (trans (caar tt) 0 1) (trans (cadar tt) 0 1)) 1e-6) "_C")
              )
            )
          )
          (vl-cmdf "_.PLINE" "_non" (trans (car (last tt)) 0 1) "_non" (polar (trans (cadr (last tt)) 0 1) (angle (trans (cadddr (last tt)) 0 1) (trans (car (last tt)) 0 1)) 1e-6) "_non" (polar (trans (caddr (last tt)) 0 1) (angle (trans (car (last tt)) 0 1) (trans (cadddr (last tt)) 0 1)) 1e-6) "_non" (trans (cadddr (last tt)) 0 1) "_C")
        )
        (setq 3df (entlast))
        (if (not (vl-catch-all-error-p (setq var (vl-catch-all-apply (function vla-addregion) (list (vlax-ename->vla-object (cdr (assoc 330 lwx))) (vlax-safearray-fill (vlax-make-safearray vlax-vbObject (cons 0 0)) (list (vlax-ename->vla-object 3df))))))))
          (progn
            (setq regobj (car (safearray-value (variant-value var))))
            (if (not (vlax-erased-p 3df))
              (entdel 3df)
            )
          )
          (setq regobj (vlax-ename->vla-object 3df))
        )
        (vl-cmdf "_.UCS" "_P")
        (vl-cmdf "_.EXTRUDE" (vlax-vla-object->ename regobj) "" "_D" "_non" (list 0.0 0.0 0.0) "_non" (list 0.0 0.0 exthig2))
        (if (/= (cdr (assoc 0 (entget (entlast)))) "3DSOLID")
          (progn
            (princ "\nEXTRUSION ERROR... Unable to EXTRUDE entity stored in vatriable : xxxreg... Quitting...")
            (setq xxxreg (vlax-vla-object->ename regobj))
            (exit)
          )
          (setq el (entlast))
        )
        (vl-cmdf "_.SUBTRACT" 3ds "" el "")
        (subtractchk 3ds el)
        (if (not (vlax-erased-p el))
          (progn
            (princ "\nSUBTRACT failure... Consider changing vector length factor - smaller value... Quitting...")
            (exit)
          )
        )
      )
    )

    (if (not (eq lw (ssname s 0)))
      (setq lwx (entget lw))
    )
    (setq pll (mapcar (function (lambda ( p ) (mapcar (function +) (list 0.0 0.0) (trans p lw 0)))) (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) lwx))))
    (setq pll (append pll (list (car pll))))
    (if (clockwise-lw lw)
      (setq pll (reverse pll))
    )
    (clean_poly lw)
    (setq lwx (entget lw))
    (setq pll (mapcar (function (lambda ( p ) (mapcar (function +) (list 0.0 0.0) (trans p lw 0)))) (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) lwx))))
    (if (eq lw (ssname s 0))
      (setq pll (unique pll))
    )
    (setq pll (append pll (list (car pll))))
    (if (clockwise-lw lw)
      (setq pll (reverse pll))
    )
    (setq tl (mapcar (function (lambda ( a b ) (list (append a (list (cdr (assoc 38 lwx)))) (append b (list (cdr (assoc 38 lwx))))))) (reverse (cdr (reverse pll))) (cdr pll)))
    (if (eq lw (ssname s 0))
      (setq pl pll)
    )
    (foreach tt tl
      (setq v1 (mapcar (function -) (cadr tt) (car tt)))
      (setq v2 (mapcar (function -) (append (mapcar (function +) (list 0.0 0.0) (polar (car tt) (+ (angle (car tt) (cadr tt)) (* 0.5 pi)) (cos (cvunit ang "degree" "radian")))) (list (+ (sin (cvunit ang "degree" "radian")) (cdr (assoc 38 lwx))))) (car tt)))
      (setq tll (cons (list tt (unit (v^v v1 v2))) tll))
    )
    (setq tll (reverse tll))
    (if (eq lw (ssname s 0))
      (setq tllo tll)
    )
    (modelling)
    (setq el (entlast))
    (vl-cmdf "_.XEDGES" 3ds "")
    (while (setq el (entnext el))
      (setq lil (cons el lil))
    )
    (setq pll (mapcar (function cdr) (apply (function append) (mapcar (function (lambda ( x ) (vl-remove-if-not (function (lambda ( y ) (vl-position (car y) (list 10 11)))) (entget x)))) lil))))
    (setq el (vl-sort (unique (mapcar (function caddr) pll)) (function <)))
    (if (not (equal (cadr el) (last el) 1e-3))
      (progn
        (setq p (vl-some (function (lambda ( x ) (if (equal (caddr x) (cadr el) 1e-6) x))) pll))
        (setq lill (vl-remove-if-not (function (lambda ( x ) (or (equal (vlax-curve-getendpoint x) p 1e-6) (equal (vlax-curve-getstartpoint x) p 1e-6)))) lil))
        (setq lill1 (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (< (caddr y) (caddr p)))) (list (vlax-curve-getstartpoint x) (vlax-curve-getendpoint x))))) lill))
        (setq lill2 (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (> (caddr y) (caddr p)))) (list (vlax-curve-getstartpoint x) (vlax-curve-getendpoint x))))) lill))
        (if (and (> (length lill1) 1) (> (length lill2) 1))
          (progn
            (setq ppl (apply (function append) (mapcar (function (lambda ( x ) (vl-remove-if (function (lambda ( y ) (equal p y 1e-6))) (list (vlax-curve-getstartpoint x) (vlax-curve-getendpoint x))))) lill)))
            (setq 3tl (list (car (setq 3tll (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (or (equal y (caar x) 1e-6) (equal y (cadar x) 1e-6)))) ppl))) (append tll tll)))) (cadr 3tll) (caddr 3tll)))
            (if (setq ip (inters (caar (car 3tl)) (cadar (car 3tl)) (caar (caddr 3tl)) (cadar (caddr 3tl)) nil))
              (progn
                (setq pp (vl-some (function (lambda ( x ) (if (and (setq pp (inters p ip (vlax-curve-getstartpoint x) (vlax-curve-getendpoint x) nil)) (not (equal (caddr pp) (caddr ip) 1e-6))) pp))) (vl-remove-if (function (lambda ( x ) (or (equal p (vlax-curve-getstartpoint x) 1e-6) (equal p (vlax-curve-getendpoint x) 1e-6)))) lil)))
                (setq ppl (list ip p (car (vl-remove-if (function (lambda ( x ) (equal p x 1e-6))) (list (vlax-curve-getstartpoint (car lill2)) (vlax-curve-getendpoint (car lill2))))) (car (vl-remove-if (function (lambda ( x ) (equal p x 1e-6))) (list (vlax-curve-getstartpoint (cadr lill2)) (vlax-curve-getendpoint (cadr lill2)))))))
                (foreach li lil
                  (if (not (vlax-erased-p li))
                    (entdel li)
                  )
                )
                (setq lil nil)
                (setq el (apply (function 4pt-3ds) ppl))
                (vl-cmdf "_.SUBTRACT" 3ds "" el "")
                (subtractchk 3ds el)
                (if (not (vlax-erased-p el))
                  (progn
                    (setq ell (vlax-vla-object->ename (vla-copy (vlax-ename->vla-object el))))
                    (vl-cmdf "_.UNION" 3ds el "")
                    (if (not (eq ell (entlast)))
                      (progn
                        (setq 3ds (entlast))
                        (vl-cmdf "_.SUBTRACT" 3ds "" ell "")
                        (subtractchk 3ds ell)
                      )
                      (if (not (vlax-erased-p 3ds))
                        (progn
                          (entdel ell)
                          (entdel el)
                        )
                        (setq 3ds el)
                      )
                    )
                  )
                )
                (setq el (entlast))
                (vl-cmdf "_.XEDGES" 3ds "")
                (while (setq el (entnext el))
                  (setq lil (cons el lil))
                )
                (setq pll (mapcar (function cdr) (apply (function append) (mapcar (function (lambda ( x ) (vl-remove-if-not (function (lambda ( y ) (vl-position (car y) (list 10 11)))) (entget x)))) lil))))
                (setq el (vl-sort (unique (mapcar (function caddr) pll)) (function <)))
                (foreach li lil
                  (if (not (vlax-erased-p li))
                    (entdel li)
                  )
                )
                (setq lil nil)
              )
            )
            (foreach li lil
              (if (not (vlax-erased-p li))
                (entdel li)
              )
            )
            (setq lil nil)
            (if (not (equal (cadr el) (last el) 1e-3))
              (list 3ds (+ (cadr el) (/ (- (caddr el) (cadr el)) 2.0)))
            )
          )
          (progn
            (foreach li lil
              (if (not (vlax-erased-p li))
                (entdel li)
              )
            )
            (setq lil nil)
            (if (not (equal (cadr el) (last el) 1e-3))
              (list 3ds (+ (cadr el) (/ (- (caddr el) (cadr el)) 2.0)))
            )
          )
        )
      )
      (progn
        (foreach li lil
          (if (not (vlax-erased-p li))
            (entdel li)
          )
        )
        (setq lil nil)
        (list 3ds nil)
      )
    )
  )

  (defun process3ds ( lw / planarizelil regl )

    (defun planarizelil ( ss / uniquelil lil elev lix pll lill plxl lix1 lix2 pp dell mall del0 uni deloverlap delfreeend )

      (defun uniquelil ( lil )
        (if lil (cons (car lil) (uniquelil (vl-remove-if (function (lambda ( x ) (or (and (equal (vlax-curve-getstartpoint x) (vlax-curve-getstartpoint (car lil)) 1e-3) (equal (vlax-curve-getendpoint x) (vlax-curve-getendpoint (car lil)) 1e-3)) (and (equal (vlax-curve-getstartpoint x) (vlax-curve-getendpoint (car lil)) 1e-3) (equal (vlax-curve-getendpoint x) (vlax-curve-getstartpoint (car lil)) 1e-3))))) lil))))
      )

      (setq lil (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex ss))))
      (setq del0 (vl-remove-if-not (function (lambda ( x ) (equal (vlax-curve-getstartpoint x) (vlax-curve-getendpoint x) 1e-3))) lil))
      (setq uni (uniquelil lil))
      (setq deloverlap (vl-remove-if (function (lambda ( x ) (vl-position x uni))) lil))
      (setq elev (caddr (vlax-curve-getstartpoint (car lil))))
      (foreach li lil
        (setq lix (entget li))
        (setq lix (subst (append (reverse (cdr (reverse (assoc 10 lix)))) (list elev)) (assoc 10 lix) lix))
        (setq lix (subst (append (reverse (cdr (reverse (assoc 11 lix)))) (list elev)) (assoc 11 lix) lix))
        (entupd (cdr (assoc -1 (entmod lix))))
      )
      (setq pll (mapcar (function cdr) (apply (function append) (mapcar (function (lambda ( x ) (vl-remove-if-not (function (lambda ( y ) (vl-position (car y) (list 10 11)))) (entget x)))) lil))))
      (setq delfreeend (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (or (equal (vlax-curve-getstartpoint x) y 1e-6) (equal (vlax-curve-getendpoint x) y 1e-6)))) (vl-remove-if-not (function (lambda ( x ) (= 1 (- (length pll) (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) pll)))))) pll)))) lil))
      (setq pll (unique pll))
      (foreach li lil
        (setq lix (entget li))
        (setq lix (subst (cons 10 (car (vl-remove-if-not (function (lambda ( x ) (equal x (cdr (assoc 10 lix)) 1e-3))) pll))) (assoc 10 lix) lix))
        (setq lix (subst (cons 11 (car (vl-remove-if-not (function (lambda ( x ) (equal x (cdr (assoc 11 lix)) 1e-3))) pll))) (assoc 11 lix) lix))
        (entupd (cdr (assoc -1 (entmod lix))))
      )
      (setq lill (mapcar (function (lambda ( x ) (mapcar (function cdr) (vl-remove-if-not (function (lambda ( y ) (vl-position (car y) (list 10 11)))) (entget x))))) lil))
      (setq plxl (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (and (equal (distance (car y) (cadr y)) (+ (distance (car y) x) (distance x (cadr y))) 1e-6) (not (equal x (car y) 1e-6)) (not (equal x (cadr y) 1e-6))))) lill))) pll))
      (foreach plx plxl
        (setq lix1 (vl-some (function (lambda ( x ) (if (and (equal (distance (car x) (cadr x)) (+ (distance (car x) plx) (distance plx (cadr x))) 1e-6) (not (equal (car x) plx 1e-6)) (not (equal (cadr x) plx 1e-6))) x))) lill))
        (setq lix2 (vl-some (function (lambda ( x ) (if (or (equal (car x) plx 1e-6) (equal (cadr x) plx 1e-6)) x))) lill))
        (setq pp (car (vl-remove-if (function (lambda ( x ) (vl-position x lix2))) lix1)))
        (setq dell (cons (vl-some (function (lambda ( x ) (if (equal (mapcar (function cdr) (vl-remove-if-not (function (lambda ( y ) (vl-position (car y) (list 10 11)))) (entget x))) lix1 1e-6) x))) lil) dell) dell (cons (vl-some (function (lambda ( x ) (if (equal (mapcar (function cdr) (vl-remove-if-not (function (lambda ( y ) (vl-position (car y) (list 10 11)))) (entget x))) lix2 1e-6) x))) lil) dell))
        (setq mall (cons (entmakex (list (cons 0 "LINE") (cons 10 pp) (cons 11 plx))) mall))
      )
      (setq dell (append dell del0 deloverlap delfreeend))
      (if dell
        (list dell mall)
      )
    )

    (setq 3ds (car (setq r (process lw))))
    (if (cadr r)
      (progn
        (vla-getboundingbox (vlax-ename->vla-object 3ds) (quote minpt) (quote maxpt))
        (setq minpt (safearray-value minpt))
        (vla-slicesolid (vlax-ename->vla-object 3ds) (vlax-3d-point (list 0.0 0.0 (cadr r))) (vlax-3d-point (list 1.0 0.0 (cadr r))) (vlax-3d-point (list 0.0 1.0 (cadr r))) :vlax-true)
        (if (vlax-erased-p 3ds)
          (progn
            (setq e1 (entlast))
            (entdel e1)
            (setq e2 (entlast))
            (entdel e1)
            (vla-getboundingbox (vlax-ename->vla-object e1) (quote e1min) (quote e1max))
            (setq e1min (safearray-value e1min))
            (vla-getboundingbox (vlax-ename->vla-object e2) (quote e2min) (quote e2max))
            (setq e2min (safearray-value e2min))
            (if (< (caddr e1min) (caddr e2min))
              (progn
                (setq 3ds e1)
                (entdel e2)
              )
              (progn
                (setq 3ds e2)
                (entdel e1)
              )
            )
          )
          (progn
            (setq e1 (entlast))
            (vla-getboundingbox (vlax-ename->vla-object e1) (quote e1min) (quote e1max))
            (setq e1min (safearray-value e1min))
            (if (< (caddr e1min) (caddr minpt))
              (progn
                (entdel 3ds)
                (setq 3ds e1)
              )
              (if (> (caddr e1min) (caddr minpt))
                (entdel e1)
                (progn
                  (princ "\n3DSOLID was not sliced... Quitting...")
                  (exit)
                )
              )
            )
          )
        )
        (setq 3dsl (cons 3ds 3dsl))
        (vl-cmdf "_.EXPLODE" (vlax-vla-object->ename (vla-copy (vlax-ename->vla-object (car 3dsl)))))
        (if (ssget "_P" (list (cons 0 "REGION")))
          (setq regl (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex (ssget "_P" (list (cons 0 "REGION")))))))
          (progn
            (princ "\nNo selection of REGIONS after EXPLODE... Quitting...")
            (exit)
          )
        )
        (if (vl-every (function (lambda ( x ) (= (type x) (quote ename)))) regl)
          (if (not (vl-every (function (lambda ( x ) (= (cdr (assoc 0 (entget x))) "REGION"))) regl))
            (setq regl (vl-remove-if-not (function (lambda ( x ) (= (cdr (assoc 0 (entget x))) "REGION"))) regl))
          )
          (setq regl (vl-remove-if-not (function (lambda ( x ) (= (type x) (quote ename)))) regl))
        )
        (foreach reg (mapcar (function vlax-ename->vla-object) regl)
          (vla-getboundingbox reg (quote minpt) (quote maxpt))
          (mapcar (function set) (list (quote minpt) (quote maxpt)) (mapcar (function safearray-value) (list minpt maxpt)))
          (if (or (not (or (equal (setq n (safearray-value (variant-value (vla-get-normal reg)))) (list 0.0 0.0 1.0) 1e-3) (equal n (list 0.0 0.0 -1.0) 1e-3))) (not (equal (caddr minpt) (cadr r) 1e-3)))
            (vla-delete reg)
          )
        )
        (setq regl (vl-remove-if (function vlax-erased-p) regl))
        (if (null regl)
          (progn
            (princ "\nAll REGIONS were deleted... Calculation mistake... Quitting...")
            (exit)
          )
        )
        (foreach reg regl
          (setq el (entlast))
          (vl-cmdf "_.EXPLODE" reg)
          (if (setq ll (if (ssget "_P" (list (cons 0 "REGION"))) (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex (ssget "_P" (list (cons 0 "REGION"))))))))
            (foreach x ll
              (progn
                (setq el (entlast) ss (ssadd))
                (vl-cmdf "_.EXPLODE" x)
                (while (setq el (entnext el))
                  (ssadd el ss)
                )
                (if (setq q (planarizelil ss))
                  (progn
                    (foreach x (car q)
                      (entdel x)
                      (ssdel x ss)
                    )
                    (if (cadr q)
                      (foreach x (cadr q)
                        (ssadd x ss)
                      )
                    )
                  )
                )
                (vl-cmdf "_.PEDIT" "_M" ss "" "_J" 0.01)
                (while (< 0 (getvar (quote cmdactive)))
                  (vl-cmdf "")
                )
                (setq lwss (cons (entlast) lwss))
              )
            )
            (progn
              (setq ss (ssadd))
              (while (setq el (entnext el))
                (ssadd el ss)
              )
              (if (setq q (planarizelil ss))
                (progn
                  (foreach x (car q)
                    (entdel x)
                    (ssdel x ss)
                  )
                  (if (cadr q)
                    (foreach x (cadr q)
                      (ssadd x ss)
                    )
                  )
                )
              )
              (vl-cmdf "_.PEDIT" "_M" ss "" "_J" 0.01)
              (while (< 0 (getvar (quote cmdactive)))
                (vl-cmdf "")
              )
              (setq lwss (cons (entlast) lwss))
            )
          )
        )
      )
      (setq 3dsl (cons 3ds 3dsl))
    )
    (if lwss
      (if (and (not (vlax-erased-p (setq lw (last lwss)))) (= (cdr (assoc 0 (setq lwx (entget lw)))) "LWPOLYLINE") (= 1 (logand 1 (cdr (assoc 70 lwx)))))
        (progn
          (setq lwe (cons lw lwe))
          (setq lwss (vl-remove lw lwss))
          (process3ds lw)
        )
        (cond
          ( (vlax-erased-p lw)
            (princ "\nLWPOLYLINE from lwss list was erased... Quitting...")
            (exit)
          )
          ( (/= (cdr (assoc 0 lwx)) "LWPOLYLINE")
            (princ (strcat "\nWrong entity type in list lwss... Should be LWPOLYLINE and is : " (cdr (assoc 0 lwx))))
            (exit)
          )
          ( (/= 1 (logand 1 (cdr (assoc 70 lwx))))
            (princ "\nLWPOLYLINE is opened - wrong processing of PEDIT JOIN... Maybe you have to small fuzz distance (0.0) - it should be just a micron above 0.0...")
            (exit)
          )
        )
      )
    )
  )

  (setq cmde (getvar (quote cmdecho)))
  (setvar (quote cmdecho) 0)
  (setq pea (getvar (quote peditaccept)))
  (setvar (quote peditaccept) 1)
  (vl-cmdf "_.UNDO" "_BE")
  (if (= 0 (getvar (quote worlducs)))
    (progn
      (vl-cmdf "_.UCS" "_W")
      (setq ucsf t)
    )
  )
  (prompt "\nPick a closed polygonal LWPOLYLINE...")
  (if (setq s (ssget "_+.:E:S" (list (cons 0 "LWPOLYLINE") (cons -4 "&=") (cons 70 1) (cons -4 "<not") (cons -4 "<>") (cons 42 0.0) (cons -4 "not>"))))
    (progn
      (initget 1 "2D 3D")
      (setq ch (getkword "\nChoose option [2D/3D] : "))
      (if (= ch "3D")
        (progn
          (initget 1 "Slope Angle")
          (setq chh (getkword "\nChoose option [Angle/Slope] : "))
          (cond
            ( (= chh "Slope")
              (initget 6)
              (setq slope (getreal "\nEnter slope in percentage <100> : "))
              (if (null slope)
                (setq slope 100.0)
              )
              (setq ang (cvunit (atan (/ slope 100.0)) "radian" "degree"))
            )
            ( t
              (initget 6)
              (setq ang (getreal "\nEnter angle in decimal degrees <45> : "))
              (if (null ang)
                (setq ang 45.0)
              )
            )
          )
        )
        (progn
          (setq ang 45.0)
          (initget "Offset Ridges Both")
          (setq chh (getkword "\nChoose an option [Offset/Ridges/Both] <Both> : "))
          (if (null chh)
            (setq chh "Both")
          )
        )
      )
      (initget 6)
      (setq vlen (getdist "\nSpecify vector length for points away from model - making subtracting 3DSOLIDS <1e+4> : "))
      (if (null vlen)
        (setq vlen 1e+4)
      )
      (initget 4)
      (setq fuzz (getdist "\nSpecify long vertices nudge fuzz distance - points away from model <2e-4> - but you can specify 0.0 : "))
      (if (null fuzz)
        (setq fuzz 2e-4)
      )
      (initget 6)
      (setq exthig1 (getdist "\nSpecify extrusion height for main 3DSOLID <5e+2> : "))
      (if (null exthig1)
        (setq exthig1 5e+2)
      )
      (initget 6)
      (setq exthig2 (getdist (strcat "\nSpecify extrusion height for subtracting 3DSOLIDS - must be greater than " (rtos exthig1 2 6) " <1e+3> : ")))
      (if (null exthig2)
        (setq exthig2 1e+3)
      )
      (while (<= exthig2 exthig1)
        (prompt "\nInvalid specification... Input value must be greater...")
        (initget 6)
        (setq exthig2 (getdist (strcat "\nSpecify extrusion height for subtracting 3DSOLIDS - must be greater than " (rtos exthig1 2 6) " <1e+3> : ")))
        (if (null exthig2)
          (setq exthig2 1e+3)
        )
      )
      (setq ti (car (_vl-times)))
      (setq lw (ssname s 0))
      (setq elev (cdr (assoc 38 (setq lwx (entget lw)))))
      (process3ds lw)
      (setq 3dsl (reverse 3dsl))
      (setq 3ds (car 3dsl))
      (foreach el (cdr 3dsl)
        (vl-cmdf "_.UNION" 3ds el "")
        (if (vlax-erased-p 3ds)
          (setq 3ds (entlast))
        )
      )
      (if (= (cdr (assoc 0 (entget 3ds))) "3DSOLID")
        (progn
          (setq el (entlast) lil nil)
          (vl-cmdf "_.XEDGES" 3ds "")
          (while (setq el (entnext el))
            (setq lil (cons el lil))
          )
          (entdel 3ds)
          (setq lil (vl-remove-if (function vlax-erased-p) (processlines (vl-remove-if (function vlax-erased-p) lil))))
          (setq pll (mapcar (function (lambda ( x ) (mapcar (function cdr) (vl-remove-if-not (function (lambda ( y ) (vl-position (car y) (list 10 11)))) (entget x))))) lil))
          (setq pll (apply (function append) pll))
          (setq singles (vl-remove-if-not (function (lambda ( x ) (= (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) pll)) (1- (length pll))))) pll))
          (foreach li lil
            (if (vl-some (function (lambda ( x ) (or (equal (cdr (assoc 10 (setq lix (entget li)))) x 1e-6) (equal (cdr (assoc 11 lix)) x 1e-6)))) singles)
              (progn
                (entdel li)
                (setq lil (vl-remove li lil))
              )
            )
          )
          (foreach li lil
            (entupd (cdr (assoc -1 (entmod (mapcar (function (lambda ( x ) (if (vl-position (car x) (list 10 11)) (list (car x) (cadr x) (caddr x) elev) x))) (setq lix (entget li)))))))
            (if (vl-every (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x (append y (list elev)) 1e-3))) pl))) (mapcar (function cdr) (vl-remove-if-not (function (lambda ( x ) (vl-position (car x) (list 10 11)))) lix)))
              (entdel li)
            )
          )
          (setq lil (vl-remove-if (function vlax-erased-p) lil))
          (setq pll (mapcar (function cdr) (apply (function append) (mapcar (function (lambda ( x ) (vl-remove-if-not (function (lambda ( y ) (vl-position (car y) (list 10 11)))) (entget x)))) lil))))
          (setq plll (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) (mapcar (function (lambda ( x ) (list (car x) (cadr x) elev))) pl)))) pll))
          (setq plxl (vl-remove-if-not (function (lambda ( x ) (= (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) plll)) (1- (length plll))))) plll))
          (setq pll (unique pll))
          (setq lill (mapcar (function (lambda ( x ) (mapcar (function cdr) (vl-remove-if-not (function (lambda ( y ) (vl-position (car y) (list 10 11)))) (entget x))))) lil))
          (setq plxl (append plxl (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (and (equal (distance (car y) (cadr y)) (+ (distance (car y) x) (distance x (cadr y))) 1e-6) (not (equal x (car y) 1e-6)) (not (equal x (cadr y) 1e-6))))) lill))) pll)))
          (setq del (vl-remove-if-not (function (lambda ( x / y ) (setq y (entget x)) (or (vl-position (cdr (assoc 10 y)) plxl) (vl-position (cdr (assoc 11 y)) plxl)))) lil))
          (foreach x del
            (if (not (vlax-erased-p x))
              (entdel x)
            )
          )
          (setq lil (vl-remove-if (function vlax-erased-p) lil))
          (if (= ch "2D")
            (cond
              ( (or (= chh "Ridges") (= chh "Both"))
                (if (= chh "Ridges")
                  (if lwe
                    (foreach lw lwe
                      (if (not (vlax-erased-p lw))
                        (entdel lw)
                      )
                    )
                  )
                  (if lwe
                    (foreach lw lwe
                      (entupd (cdr (assoc -1 (entmod (subst (cons 38 elev) (assoc 38 (setq lwx (entget lw))) lwx)))))
                    )
                  )
                )
              )
              ( t
                (foreach li lil
                  (if (not (vlax-erased-p li))
                    (entdel li)
                  )
                )
                (if lwe
                  (foreach lw lwe
                    (entupd (cdr (assoc -1 (entmod (subst (cons 38 elev) (assoc 38 (setq lwx (entget lw))) lwx)))))
                  )
                )
              )
            )
            (progn
              (if lwe
                (foreach lw lwe
                  (if (not (vlax-erased-p lw))
                    (entdel lw)
                  )
                )
              )
              (2droof3d (ssname s 0))
            )
          )
        )
      )
      (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 16)) (prompt " milliseconds...")
    )
  )
  (if ucsf
    (vl-cmdf "_.UCS" "_P")
  )
  (vl-cmdf "_.UNDO" "_E")
  (*error* nil)
)